#extension GL_EXT_gpu_shader4 : enable

attribute vec3 p0; 
attribute vec3 p1; 
attribute vec2 texcoord; 
attribute vec2 texcoord2;  

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 world;
uniform vec3 eyePos; 
uniform float grow; //levels*time
uniform float linesize = 0.5f;
uniform float t; 
varying vec2 tc; 
varying vec3 color; 
varying float fogCoef;
//random E[-1, 1]
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}



float fogFar = 2500.0;
float lineWidth = 0.75;
void main()
{

	//unique line attributes
	float lineLength = .10*rand(p0.xy*100.0);
	float speed = .3*abs(rand(p0.yx));
	float offset = fract(.3*abs(rand(p0.zy))+t*speed);
	

	//two new points on line created
	vec3 np0 = p0;//mix(p0, p1, offset);
	vec3 np1 = p1;//ix(p0, p1, offset+lineLength);

	vec3 vp0 = (vec4(np0, 1.0)).xyz;
	vec3 vp1 = (vec4(np1, 1.0)).xyz;
	
	// construct a new p1 = np2;

   // np1 = p1;//mix(p0, p1, clamp((texcoord2.x), 0.0, 1.0)); 
	
	vec3 add = mix(vp0,vp1,texcoord.y);
	vec3 e2n = normalize(eyePos-add);
	vec3 a2b = normalize(np1-np0);
	float sss = 2.0/(1.0+texcoord2.x);
	vec3 n2s = sss*cross(e2n, a2b);
	vec3 npos = add;
	npos += lineWidth*mix(n2s, -n2s, texcoord.x);
	
	gl_Position = viewproj*vec4(npos, 1.0);
	tc = texcoord.xy;

	color = vec3(1.)*length(eyePos-add);
	color = length(add-eyePos)*.03f;


	float dist = clamp(1.0-length(add.xyz-eyePos)/fogFar, 0.0, 1.0);
	fogCoef = dist*dist*1.0;//*texcoord.y;
}

//FRAGMENT
varying vec2 tc;
varying vec3 color; 
varying float fogCoef;
uniform sampler2D Texture0;
uniform float alpha_mul=1.0; 

void main() {
	gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
//	gl_FragColor = texture2D(Texture0, tc);
	gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);
	gl_FragColor.a = 0.2;

	gl_FragColor = vec4(1.0);
	gl_FragColor.a = .250*fogCoef;
	//gl_FragColor.a = tc.y*tc.y*tc.y*tc.y*.226;
	//gl_FragColor = vec4(1.0, 0.0, 0.0, 0.0, 1.0);
}

